Attribute VB_Name = "modGeneral"
Option Explicit


   Public Const REG_SZ As Long = 1
   Public Const REG_DWORD As Long = 4


   Const STANDARD_RIGHTS_ALL = &H1F0000
   
Const KEY_QUERY_VALUE = &H1
Const KEY_SET_VALUE = &H2
Const KEY_CREATE_SUB_KEY = &H4
Const KEY_ENUMERATE_SUB_KEYS = &H8
Const KEY_NOTIFY = &H10
Const KEY_CREATE_LINK = &H20
Const SYNCHRONIZE = &H100000

   Public Const ERROR_NONE = 0
   Public Const ERROR_BADDB = 1
   Public Const ERROR_BADKEY = 2
   Public Const ERROR_CANTOPEN = 3
   Public Const ERROR_CANTREAD = 4
   Public Const ERROR_CANTWRITE = 5
   Public Const ERROR_OUTOFMEMORY = 6
   Public Const ERROR_ARENA_TRASHED = 7
   Public Const ERROR_ACCESS_DENIED = 8
   Public Const ERROR_INVALID_PARAMETERS = 87
   Public Const ERROR_NO_MORE_ITEMS = 259

   Public Const KEY_ALL_ACCESS = &H3F

   Public Const REG_OPTION_NON_VOLATILE = 0

   
Const HKEY_CLASSES_ROOT = &H80000000
Const HKEY_CURRENT_USER = &H80000001
Const HKEY_LOCAL_MACHINE = &H80000002
Const HKEY_USERS = &H80000003
Const HKEY_PERFORMANCE_DATA = &H80000004
Const HKEY_CURRENT_CONFIG = &H80000005
Const HKEY_DYN_DATA = &H80000006

Declare Function RegQueryValueEx Lib "advapi32.dll" Alias "RegQueryValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal lpReserved As Long, lpType As Long, lpData As Any, lpcbData As Long) As Long         ' Note that if you declare the lpData parameter as String, you must pass it By Value.
Declare Function RegCloseKey Lib "advapi32.dll" _
   (ByVal hKey As Long) As Long
   Declare Function RegCreateKeyEx Lib "advapi32.dll" Alias _
   "RegCreateKeyExA" (ByVal hKey As Long, ByVal lpSubKey As String, _
   ByVal Reserved As Long, ByVal lpClass As String, ByVal dwOptions _
   As Long, ByVal samDesired As Long, ByVal lpSecurityAttributes _
   As Long, phkResult As Long, lpdwDisposition As Long) As Long
   Declare Function RegOpenKeyEx Lib "advapi32.dll" Alias _
   "RegOpenKeyExA" (ByVal hKey As Long, ByVal lpSubKey As String, _
   ByVal ulOptions As Long, ByVal samDesired As Long, phkResult As _
   Long) As Long
   Declare Function RegQueryValueExString Lib "advapi32.dll" Alias _
   "RegQueryValueExA" (ByVal hKey As Long, ByVal lpValueName As _
   String, ByVal lpReserved As Long, lpType As Long, ByVal lpData _
   As String, lpcbData As Long) As Long
   Declare Function RegQueryValueExLong Lib "advapi32.dll" Alias _
   "RegQueryValueExA" (ByVal hKey As Long, ByVal lpValueName As _
   String, ByVal lpReserved As Long, lpType As Long, lpData As _
   Long, lpcbData As Long) As Long
   Declare Function RegQueryValueExNULL Lib "advapi32.dll" Alias _
   "RegQueryValueExA" (ByVal hKey As Long, ByVal lpValueName As _
   String, ByVal lpReserved As Long, lpType As Long, ByVal lpData _
   As Long, lpcbData As Long) As Long
   Declare Function RegSetValueExString Lib "advapi32.dll" Alias _
   "RegSetValueExA" (ByVal hKey As Long, ByVal lpValueName As String, _
   ByVal Reserved As Long, ByVal dwType As Long, ByVal lpValue As _
   String, ByVal cbData As Long) As Long
   Declare Function RegSetValueExLong Lib "advapi32.dll" Alias _
   "RegSetValueExA" (ByVal hKey As Long, ByVal lpValueName As String, _
   ByVal Reserved As Long, ByVal dwType As Long, lpValue As Long, _
   ByVal cbData As Long) As Long



Public Enum RangeUnits
  ruFathoms
  ruFeet
  ruMeters
End Enum

Public Type CommParametersT
  baudRate As Long
  CharacterSize As Integer
  CommPort As Integer
  Parity As Integer
End Type

Public Type GeneralT
  appOrigin As String
  classifier As ClassifierClass
  dBSourcePrefix As String
  developmentDB As DbConnectionClass
  maintenanceMode As Boolean
  Gps As GpsClass
  parametersDb As DbConnectionClass
  pingDB As DbConnectionClass
  propertyList As PropertyListClass
  sonarIF As SonarClass
  sonarParametersName As String
End Type
'DFL KB#72 / KB#73
Public Const MaxArraySize = 65536 * 32 '65536 *2=131072
Public Const NominalSoundSpeed = 1500 ' m/s

Public general As GeneralT
'Private Sub GetInitialSonarParameters()
'
'  Dim interval As Long
'  Dim salinity As Long
'  Dim sonarParameters As New SonarParametersClass
'  Dim sonarparametersid As String
'  Dim speedOfSound As Long
'
'  general.sonarParametersName = ""
'  On Error GoTo oops
'
'  With general
'
'    salinity = .propertyList.GetProperty("General:Salinity", 0)
'    .sonarIF.SetSalinity salinity
'    speedOfSound = .propertyList.GetProperty("General:SpeedOfSound", 1500)
'    .sonarIF.SetSpeedOfSound speedOfSound
'    interval = .propertyList.GetProperty("General:PingInterval", 100)
'    .sonarIF.SetPingInterval interval
'    .sonarIF.SetPingLogging .propertyList.GetProperty("General:PingLogging", True)
'    .sonarIF.SetEchoLogging .propertyList.GetProperty("General:EchoLogging", True)
'
'    Set .sonarConfiguration = New SonarConfigurationClass
'    .sonarConfiguration.ReadFromDB Name:="_Default"
'
'    sonarparametersid = _
'      .propertyList.GetProperty("General:SonarParameters", "")
'
'    If sonarparametersid <> "" Then
'
'      sonarParameters.ReadFromDB .dBSourcePrefix & .parametersDbFile, _
'        targetID:=sonarparametersid
'
'      sonarParameters.applyParameters .sonarIF
'
'      .sonarParametersName = sonarParameters.GetName
'
'    End If
'
'    .sonarIF.RefreshAllParameters
'
'  End With ' general
'
'  Exit Sub
'
'oops:
'
'  ErrorBox boxCaption:="Initial Parameter Load Failure"
'  general.sonarIF.RefreshAllParameters
'
'End Sub
Public Sub ChangePingDatabase(ByVal newDB As Boolean, cdlOpen As CommonDialog)

  Dim oldFile As String
  Dim theFile As String

  On Error GoTo oops
  theFile = OpenDB(cdlOpen, dbPing, newDB)
  If theFile <> "" Then
    oldFile = general.pingDB.GetFile
    general.pingDB.dbClose
    general.pingDB.SetFile theFile
    general.pingDB.dbOpen
    If general.pingDB.GetType <> "ping" Then
      general.pingDB.dbClose
      Err.Raise utilGeneralError, , "Not a ping database"
    End If
    general.propertyList.SetProperty "General:PingDB", general.pingDB.GetFile()
  End If
  
  Exit Sub
  
oops:

  ErrorBox boxCaption:="Ping Database Open Failure", _
    bodyPrefix:="Following error occurred; ping database not changed:" & vbCrLf
  general.pingDB.SetFile oldFile
  general.pingDB.dbOpen

End Sub
Public Function OpenDB(cdlOpen As CommonDialog, dbType As DBTypesT, _
                       Optional ByVal newDB As Boolean = False) As String

'Creates a new database file of one of the specified types.
'Copies the template file into the specified file and makes it
'readable.
'
'Returns the new db name if successful, otherwise returns the empty string.

  Dim theFile As String
  Dim templateName As String

  With cdlOpen
  
    Select Case dbType
    
      Case dbPing
        .DefaultExt = "mdb"
        .Filter = "Ping (*.mdb)|*.mdb|All files|*.*"
        templateName = "\dbTemplates\pingData-template.mdb"
        
      Case dbDevelopment
        .DefaultExt = "mdb"
        .Filter = "Development (*.mdb)|*.mdb|All files|*.*"
        templateName = "\dbTemplates\development-template.mdb"
      
      Case dbParameters
        .DefaultExt = "mdb"
        .Filter = "Parameters (*.mdb)|*.mdb|All files|*.*"
        templateName = "\dbTemplates\scifish2000-template.mdb"
    
    End Select
    
    .InitDir = general.appOrigin
    .filename = Format(Now(), "yyyymmddhhNn") & ".mdb"
    .CancelError = True
    .FilterIndex = 1
    
    On Error GoTo cancelled
    
    If newDB Then
      .flags = (cdlOFNOverwritePrompt + cdlOFNPathMustExist)
      .ShowSave
    Else
      .flags = cdlOFNFileMustExist + cdlOFNNoReadOnlyReturn
      .ShowOpen
    End If

    On Error GoTo oops
    
    theFile = .filename
    
    If newDB Then
      FileCopy general.appOrigin & templateName, theFile
      SetAttr theFile, vbNormal
    Else
      ' Consider adding a way to do a cursory check to see if
      ' the file selected is a database and contains the right tables
    End If
  End With
  
  OpenDB = theFile
  Exit Function
  
oops:

  MsgBox "Error #" & Err.number & ": " & Err.description, _
    vbExclamation + vbOKOnly, "Database Creation Error"
  OpenDB = ""

  Exit Function
  
cancelled:

  OpenDB = ""

End Function
Public Sub Main()
  
  Randomize
  frmSplash.Show
  DoEvents

  With general
  
     .maintenanceMode = False
           
    .appOrigin = App.Path & "\.."
    
      
    Set .parametersDb = New DbConnectionClass
    .parametersDb.SetFile .appOrigin & "\data\SciFish2000.mdb"
    Dim ok As Boolean
    ok = FileExists(.parametersDb.GetFile, writable:=True)
    
    If Not ok Then
      MsgBox "The parameters file '" & .parametersDb.GetFile & "'" & vbCrLf & _
           " must exist and be writable for proper program operation." & _
           vbCrLf, _
           vbOKOnly + vbCritical, "Parameter File Anomaly"
      Exit Sub
    End If
    .parametersDb.dbOpen
    
    Set .propertyList = New PropertyListClass
    .propertyList.SetDb .parametersDb
    
    Set .sonarIF = New SonarClass
    
    Set .developmentDB = New DbConnectionClass
    .developmentDB.SetFile .propertyList.GetProperty("General:DevelopmentDB", _
                                                     .appOrigin & "\data\development.mdb")
    If Not FileExists(.developmentDB.GetFile, writable:=True) Then
      .developmentDB.SetFile ""
    Else
      ' JG - Bug 191
      Dim altr_devdb As String
      altr_devdb = "Alter table TmpPingSeries alter column name text(255)"
      .developmentDB.dbOpen
      .developmentDB.Execute altr_devdb
    End If
    
    Set .pingDB = New DbConnectionClass
    .pingDB.SetFile .propertyList.GetProperty("General:PingDB", _
                                              .appOrigin & "\data\pingData.mdb")
    If Not FileExists(.pingDB.GetFile, writable:=True) Then
      .pingDB.SetFile ""
    Else
      .pingDB.dbOpen
    End If
              
  End With
  
  
  Dim configuration As New SonarConfigurationClass
  Set configuration = New SonarConfigurationClass
  Dim name As String
  name = general.propertyList.GetProperty("General:SonarConfigurationName", "_Default")
  On Error GoTo there
  configuration.ReadFromDB name:=name
there:
  If Not configuration.IsValid Then
    configuration.ReadFromDB name:="_Default"
  End If
  general.sonarIF.SetSonarConfiguration configuration
    
  Load frmCollection
  general.sonarIF.Construct frmCollection.SonarOCX, frmCollection.tmrSonar
  
    
  Set frmCollection.sonarIF = general.sonarIF
  If general.propertyList.GetProperty("General:Maximized", True) Then
    frmCollection.WindowState = vbMaximized
  Else
    frmCollection.WindowState = vbMaximized
  End If
    
  'general.maintenanceMode = general.propertyList.GetProperty("General:maintenanceMode", False)
  If Not general.maintenanceMode Then
    general.sonarIF.SetPlaybackMode False
  Else
    general.sonarIF.SetPlaybackMode general.propertyList.GetProperty("General:PlaybackMode", False)
    If general.sonarIF.isPlayback And general.pingDB.GetFile <> "" Then
      With general.propertyList
        Dim pingSeriesName As String
        pingSeriesName = .GetProperty("Playback:PingSeriesName", "")
        If pingSeriesName <> "" Then
          general.sonarIF.SetPingSeriesName pingSeriesName
          general.sonarIF.SetPingSeriesID .GetProperty("Playback:PingSeriesID", "")
          general.sonarIF.SetPingCount .GetProperty("Playback:PingCount", 0)
          general.sonarIF.SetPingInterval .GetProperty("Playback:PingInterval", 0)
          general.sonarIF.SetManualPing .GetProperty("Playback:ManualPing", False)
          general.sonarIF.SetLoopPlayback .GetProperty("Playback:LoopPlayback", False)
        End If
      End With
    End If
  End If
  
  '  Configure and activate the GPS, if appropriate.
  
  Set general.Gps = New GpsClass
  frmCollection.setGps
  general.Gps.SetCommControl frmCollection.comGps
  If general.propertyList.GetProperty("General:UseGps", False) Then
    general.Gps.Activate True, general.propertyList.GetProperty("General:GpsComPort", 1)
  End If

  Sleep (1000) ' Show it at least 1 second
  frmSplash.Hide
  frmCollection.Show
  Unload frmSplash
  
End Sub

   Public Sub QueryValue(sKeyName As String, sValueName As String)
       Dim lRetVal As Long         'result of the API functions
       Dim hKey As Long         'handle of opened key
       Dim vValue As Variant      'setting of queried value

       lRetVal = RegOpenKeyEx(HKEY_LOCAL_MACHINE, sKeyName, 0, _
   KEY_ALL_ACCESS, hKey)
       lRetVal = QueryValueEx(hKey, sValueName, vValue)
       MsgBox vValue
       RegCloseKey (hKey)
   End Sub


   Function QueryValueEx(ByVal lhKey As Long, ByVal szValueName As _
   String, vValue As Variant) As Long
       Dim cch As Long
       Dim lrc As Long
       Dim lType As Long
       Dim lValue As Long
       Dim sValue As String

       On Error GoTo QueryValueExError

       ' Determine the size and type of data to be read
       lrc = RegQueryValueExNULL(lhKey, szValueName, 0&, lType, 0&, cch)
       If lrc <> ERROR_NONE Then Error 5

       Select Case lType
           ' For strings
           Case REG_SZ:
               sValue = String(cch, 0)

   lrc = RegQueryValueExString(lhKey, szValueName, 0&, lType, _
   sValue, cch)
               If lrc = ERROR_NONE Then
                   vValue = Left$(sValue, cch - 1)
               Else
                   vValue = Empty
               End If
           ' For DWORDS
           Case REG_DWORD:
   lrc = RegQueryValueExLong(lhKey, szValueName, 0&, lType, _
   lValue, cch)
               If lrc = ERROR_NONE Then vValue = lValue
           Case Else
               'all other data types not supported
               lrc = -1
       End Select

QueryValueExExit:
       QueryValueEx = lrc
       Exit Function

QueryValueExError:
       Resume QueryValueExExit
   End Function





